/* Historisierendes Datenmodell */
-- Abfrage gegen JOB_HISTORY (Als Benutzer HR ausführen)
select e.employee_id, e.first_name, e.last_name, 
       nvl(jh.job_id, e.job_id) job_id
  from employees e
  left join job_history jh 
    on e.employee_id = jh.employee_id
 where to_date('15.05.2004', 'dd.mm.yyyy') 
       between nvl(jh.start_date, e.hire_date) 
           and nvl(jh.end_date, sysdate);


-- Umbau des Datenmodells im Benutzer HR_NEW
-- Erzeugung eines neuen Benutzers HR_NEW (Als SYSTEM ausführen)
connect system
create user hr_new identified by hr_new;
-- Basisrollen CONNECT und RESOURCE erteilen (kein Exempel für Produktionscode!)
grant connect, resource to hr_new;

-- Leserechte auf allen Tabellen von HR and HR_NEW erteilen (Als Benutzer HR ausführen)
connect hr/hr

declare
  cursor my_tables is
    select table_name
      from user_tables;
begin
  for tbl in my_tables loop
    execute immediate 'grant all on ' || tbl.table_name || ' to hr_new';
  end loop;
end;
/



-- Neues Datenmodell aus HR ableiten (Als Benutzer HR_NEW ausführen)
connect hr_new/hr_new

/* 
-- Folgende Anweisungen ausführen, falls der Skript erneut ausgeführt werden soll
drop table employees_jobs;
drop table employees_departments;
drop table jobs;
drop table departments;
drop table employees;
*/

-- CTAS-Anweisungen
create table employees as
select employee_id, first_name, last_name, hire_date, 
       email, phone_number, salary, commission_pct
  from hr.employees;

alter table employees add constraint employees_pk primary key (employee_id);


create table departments as
select department_id, department_name
  from hr.departments;

alter table departments 
  add constraint departments_pk 
      primary key (department_id);


create table jobs as
select job_id, job_title, min_salary, max_salary
  from hr.jobs;

alter table jobs 
  add constraint jobs_pk 
      primary key (job_id);


create table employees_departments as
select e.employee_id, 
       nvl(j.department_id, e.department_id) department_id,
       nvl(j.start_date, e.hire_date) valid_from,
       nvl(j.end_date + interval '23:59:59' hour to second,
           to_date('31.12.2099', 'dd.mm.yyyy')) valid_to
  from hr.employees e left join hr.job_history j
    on e.employee_id = j.employee_id
 where e.department_id is not null
union all
-- Aktueller Bestand für alle Mitarbeiter mit Job-History-Einträgen
 select e.employee_id, e.department_id,
        max(j.end_date) + interval '1' day, 
        max(to_date('31.12.2099', 'dd.mm.yyyy'))
   from hr.employees e
   join hr.job_history j
     on e.employee_id = j.employee_id
  group by e.employee_id, e.department_id;

alter table employees_departments 
  add constraint emp_dept_emp_fk foreign key (employee_id)
      references employees(employee_id);

alter table employees_departments 
  add constraint emp_dept_dept_fk foreign key (department_id)
      references departments(department_id);
      
alter table employees_departments
  add constraint emp_dept_pk primary key (employee_id, department_id, valid_from);


create table employees_jobs as
select e.employee_id,
       nvl(j.job_id, e.job_id) job_id,
       nvl(j.start_date, e.hire_date) valid_from,
       nvl(j.end_date + interval '23:59:59' hour to second,
           to_date('31.12.2099', 'dd.mm.yyyy')) valid_to
  from hr.employees e left join hr.job_history j
    on e.employee_id = j.employee_id
 where e.job_id is not null
union all
-- Aktueller Bestand für alle Mitarbeiter mit Job-History-Einträgen
 select e.employee_id, e.job_id,
        max(j.end_date) + interval '1' day, 
        max(to_date('31.12.2099', 'dd.mm.yyyy'))
   from hr.employees e
   join hr.job_history j
     on e.employee_id = j.employee_id
  group by e.employee_id, e.job_id;

alter table employees_jobs
  add constraint emp_job_emp_fk foreign key (employee_id)
      references employees(employee_id);

alter table employees_jobs
  add constraint emp_job_job_fk foreign key (job_id)
      references jobs(job_id);
      
alter table employees_jobs
  add constraint emp_job_pk primary key (employee_id, job_id, valid_from);
  

-- Kapselung der Daten in einer VIEW
create or replace view employees_actual as
select e.employee_id, e.first_name, e.last_name,
       e.hire_date, e.email, e.phone_number, 
       e.salary, e.commission_pct,
       d.department_id, d.department_name,
       j.job_id, j.job_title
  from employees e, departments d, jobs j,
       employees_departments ed,
       employees_jobs ej
 where e.employee_id = ed.employee_id
   and ed.department_id = d.department_id
   and sysdate between ed.valid_from and ed.valid_to
   and e.employee_id = ej.employee_id
   and ej.job_id = j.job_id
   and sysdate between ej.valid_from and ej.valid_to;
   
   
create or replace view employees_history as
select e.employee_id, e.first_name, e.last_name,
       e.hire_date, e.email, e.phone_number, 
       e.salary, e.commission_pct,
       d.department_id, d.department_name,
       j.job_id, j.job_title,
       t.time_id
  from employees e, departments d, jobs j,
       employees_departments ed,
       employees_jobs ej,
       times t
 where e.employee_id = ed.employee_id
   and ed.department_id = d.department_id
   and t.time_id between ed.valid_from and ed.valid_to
   and e.employee_id = ej.employee_id
   and ej.job_id = j.job_id
   and t.time_id between ej.valid_from and ej.valid_to;
   
   
-- Zwei Beispielabfragen gegen die Views
select employee_id, first_name, last_name, hire_date,
       email, phone_number,
       department_name, job_title
  from employee_actual
 where employee_id = 101;
 
select employee_id, first_name, last_name, hire_date,
       email, phone_number,
       department_name, job_title
  from employee_history
 where employee_id = 101
   and time_id = to_date('15.05.2004', 'dd.mm.yyyy');